<?php
/*
Plugin Name: Daemon Synesis Plugin
Description: Plugin para criar e gerenciar janelas modais no WordPress.
Version: 1.0
Author: Bruno Accioly
*/

if (!defined('ABSPATH')) exit; // Exit if accessed directly

// Adiciona o shortcode
add_shortcode('daemon_synesis', 'daemon_synesis_shortcode');

function daemon_synesis_shortcode()
{
    ob_start();
    ?>
    <div id="daemon-synesis-container">
        <!-- Barra inferior -->
        <div id="daemon-synesis-bar" style="background: #333; color: #fff; padding: 10px; position: fixed; bottom: 0; width: 100%; display: flex; justify-content: space-between;">
            <button id="menu-button" style="background: #555; color: #fff; border: none; padding: 10px;">Menu</button>
            <button id="eye-button" style="background: #555; color: #fff; border: none; padding: 10px;">👁</button>
        </div>

        <!-- Controles principais -->
        <div id="daemon-controls" style="background: #f9f9f9; padding: 20px; margin: 10px 0; border: 1px solid #ccc; box-shadow: 0 2px 5px rgba(0, 0, 0, 0.2);">
            <form id="my-form">
                <h2>Configuration</h2>

                <!-- Botões -->
                <fieldset id="config-button">
                    <legend>Buttons</legend>
                    <div>
                        <input type="checkbox" id="button-close" checked />
                        <label for="button-close">Close button</label>
                    </div>
                    <div>
                        <input type="checkbox" id="button-maximize" checked />
                        <label for="button-maximize">Maximize button</label>
                    </div>
                    <div>
                        <input type="checkbox" id="button-minimize" checked />
                        <label for="button-minimize">Minimize button</label>
                    </div>
                    <div>
                        <input type="checkbox" id="button-collapse" checked />
                        <label for="button-collapse">Collapse button</label>
                    </div>
                </fieldset>

                <!-- Dimensões -->
                <fieldset id="config-dim">
                    <legend>Width and Height</legend>
                    <label>Width: <input type="text" id="window-width" value="584" /></label><br>
                    <label>Height: <input type="text" id="window-height" value="297" /></label>
                </fieldset>

                <!-- Configuração de ícones -->
                <fieldset id="config-icon">
                    <legend>Icons</legend>
                    <label for="icon-close">Close:</label>
                    <select id="icon-close">
                        <option value="ui-icon-closethick">(default)</option>
                        <option value="ui-icon-close">ui-icon-close</option>
                    </select>
                </fieldset>

                <!-- Configuração de eventos -->
                <fieldset id="config-event">
                    <legend>Events</legend>
                    <div>
                        <input type="checkbox" id="event-load" rel="load" checked />
                        <label for="event-load">Load</label>
                    </div>
                    <div>
                        <input type="checkbox" id="event-maximize" rel="maximize" checked />
                        <label for="event-maximize">Maximize</label>
                    </div>
                </fieldset>

                <!-- Botões de ação -->
                <footer style="margin-top: 20px;">
                    <button type="button" id="new-dialog">New dialog</button>
                    <button type="button" id="iframe-dialog">iFrame dialog</button>
                    <button type="button" id="youtube-dialog">YouTube dialog</button>
                </footer>
            </form>
        </div>
    </div>
    <?php
    return ob_get_clean();
}

// Adiciona scripts e estilos
add_action('wp_enqueue_scripts', 'daemon_synesis_enqueue_scripts');
function daemon_synesis_enqueue_scripts()
{
    wp_enqueue_script('jquery-ui-dialog');
    wp_enqueue_script('daemon-synesis-script', plugin_dir_url(__FILE__) . 'assets/js/daemon-synesis.js', array('jquery', 'jquery-ui-dialog'), '1.0', true);
    wp_enqueue_style('jquery-ui-style', 'https://code.jquery.com/ui/1.12.1/themes/smoothness/jquery-ui.css');
    wp_enqueue_style('daemon-synesis-style', plugin_dir_url(__FILE__) . 'assets/css/daemon-synesis.css');
}
