jQuery(document).ready(function ($) {
    let lastDialog;

    // Criar nova janela
    $("#new-dialog").on("click", function () {
        const dialogOptions = {
            title: $("#title-text").val() || "Default Title",
            width: parseInt($("#window-width").val()) || 400,
            height: parseInt($("#window-height").val()) || 300,
            modal: $("#is-modal").is(":checked"),
            resizable: $("#is-resizable").is(":checked"),
            draggable: $("#is-draggable").is(":checked"),
            close: function () {
                $(this).dialog("destroy").remove();
            }
        };

        const dialogExtendOptions = {
            closable: $("#button-close").is(":checked"),
            maximizable: $("#button-maximize").is(":checked"),
            minimizable: $("#button-minimize").is(":checked"),
            collapsable: $("#button-collapse").is(":checked")
        };

        lastDialog = $("<div />")
            .dialog(dialogOptions)
            .dialogExtend(dialogExtendOptions);
    });

    // Abrir iFrame
    $("#iframe-dialog").on("click", function () {
        $("<div />")
            .html('<iframe src="https://example.com" style="width:100%;height:100%;border:none;"></iframe>')
            .dialog({
                title: "iFrame Dialog",
                width: 600,
                height: 400
            });
    });

    // Abrir YouTube
    $("#youtube-dialog").on("click", function () {
        $("<div />")
            .html('<iframe src="https://www.youtube.com/embed/dQw4w9WgXcQ" style="width:100%;height:100%;border:none;"></iframe>')
            .dialog({
                title: "YouTube Dialog",
                width: 640,
                height: 360
            });
    });
});
